/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class FTBEWorldData {
    public static final LevelResource FTBESSENTIALS_DIRECTORY = new LevelResource("ftbessentials");
    public static FTBEWorldData instance;
    public final MinecraftServer server;
    public boolean save;
    public final Map<String, TeleportPos> warps;

    public FTBEWorldData(MinecraftServer s) {
        this.server = s;
        this.warps = new LinkedHashMap<String, TeleportPos>();
    }

    public Path mkdirs(String path) {
        Path dir = this.server.m_129843_(FTBESSENTIALS_DIRECTORY);
        if (!path.isEmpty()) {
            dir = dir.resolve(path);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create FTB Essentials data directory: " + ex);
            }
        }
        return dir;
    }

    public void save() {
        this.save = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        SNBTCompoundTag wm = new SNBTCompoundTag();
        for (Map.Entry<String, TeleportPos> h : this.warps.entrySet()) {
            wm.m_128365_(h.getKey(), (Tag)h.getValue().write());
        }
        tag.m_128365_("warps", (Tag)wm);
        return tag;
    }

    public void read(SNBTCompoundTag tag) {
        this.warps.clear();
        SNBTCompoundTag w = tag.getCompound("warps");
        for (String key : w.m_128431_()) {
            this.warps.put(key, new TeleportPos((CompoundTag)w.getCompound(key)));
        }
    }
}

